package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.util.Export.ExportHandler;
import easik.sketch.util.Export.SaveForSQL;
import easik.sketch.util.Export.Database.DatabaseBuilder;
import easik.sketch.util.Export.Database.DatabaseUI;


/**
 *	
 *	Action to export the current sketch as SQL.
 *  
 * @author Rob Fletcher 2005
 * @author Vera Ranieri 2006
 * @author Kevin Green 2006
 * @since 2006-05-11 Vera Ranieri
 * @version 2006-08-21 Kevin Green
 */

public class ExportSQLAction extends AbstractAction {
	
	/**
	 * Create a new ExportSQLAction.  Adds a new menu item to the File menu.
	 */
	public ExportSQLAction() {
		super("Export SQL");		
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_Q));
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Generate an SQL schema");		
	}
	
	/**
	 * Exports the current sketch as an SQL database.  Displays a message if an error occurred.
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		if(Easik.getInstance().getFrame().getSketch().containsMultiEdges()){
			JOptionPane.showMessageDialog(null, "The sketch contains multiple edges between entities.\nThis feature is not supported by the export feature.\nPlease remove the extra edges and try again",
					"Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		try{	
			
			ArrayList  activeTypes = Easik.getInstance().getFrame().getSketch().getDataTypeController().getActiveTypes();
			
			Object[] possibilities = activeTypes.toArray();
			
			String choice = (String)JOptionPane.showInputDialog(null, "Choose Export Platform", "Export",
					JOptionPane.INFORMATION_MESSAGE, null, possibilities, possibilities[0]);
			if(choice !=null){	
				ExportHandler sh = SaveForSQL.saveAction(choice);
				
				//checks to make sure saveAction worked.
				if(sh != null){
					DatabaseUI udb = new DatabaseUI();
					
					if(udb.isAccepted()) {
						new DatabaseBuilder(sh, udb);
					}
				}
			}
		}
		catch(ArrayIndexOutOfBoundsException q){
			JOptionPane.showMessageDialog(null, "At least one database platform must be selected to export.",
					"Error", JOptionPane.ERROR_MESSAGE);
		}
		catch(Exception x){
			JOptionPane.showMessageDialog(null, "Error occurred while retrieving data from XML file.\n " +
					"Database not created.", "Error", JOptionPane.ERROR_MESSAGE);
			x.printStackTrace();
		}
	}
}
